<?php
namespace MMP;

use MMP\Maps_Marker_Pro as MMP;

class Menus {
	/**
	 * Registers the hooks
	 *
	 * @since 4.0
	 */
	public function init() {
		add_action('admin_menu', array($this, 'add_menu'));
		add_action('admin_head', array($this, 'admin_menu_css'));
		if (MMP::$settings['adminBar']) {
			add_action('admin_bar_menu', array($this, 'add_admin_bar_menu'), 149);
			add_action('wp_head', array($this, 'admin_bar_css'));
			add_action('admin_head', array($this, 'admin_bar_css'));
		}
	}

	/**
	 * Adds the menu to the backend
	 *
	 * @since 4.0
	 */
	public function add_menu() {
		add_menu_page(
			'Maps Marker Pro',
			'Maps Marker Pro',
			'mmp_view_maps',
			'mapsmarkerpro_maps',
			array(MMP::get_instance('MMP\Menu\Maps'), 'display'),
			$this->get_icon_svg(),
			'25.01'
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('List all maps', 'mmp'),
			'<i class="dashicons dashicons-editor-table mmp-menu-icon"></i>' . esc_html__('List all maps', 'mmp'),
			'mmp_view_maps',
			'mapsmarkerpro_maps',
			array(MMP::get_instance('MMP\Menu\Maps'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('Add or edit map', 'mmp'),
			'<i class="dashicons dashicons-plus mmp-menu-icon"></i>' . esc_html__('Add new map', 'mmp'),
			'mmp_add_maps',
			'mapsmarkerpro_map',
			array(MMP::get_instance('MMP\Menu\Map'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('List all markers', 'mmp'),
			'<i class="dashicons dashicons-editor-table mmp-menu-icon"></i>' . esc_html__('List all markers', 'mmp'),
			'mmp_view_markers',
			'mapsmarkerpro_markers',
			array(MMP::get_instance('MMP\Menu\Markers'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('Add or edit marker', 'mmp'),
			'<i class="dashicons dashicons-plus mmp-menu-icon"></i>' . esc_html__('Add new marker', 'mmp'),
			'mmp_add_markers',
			'mapsmarkerpro_marker',
			array(MMP::get_instance('MMP\Menu\Marker'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('Tools', 'mmp'),
			'<i class="dashicons dashicons-admin-tools mmp-menu-icon"></i>' . esc_html__('Tools', 'mmp'),
			'mmp_use_tools',
			'mapsmarkerpro_tools',
			array(MMP::get_instance('MMP\Menu\Tools'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('Settings', 'mmp'),
			'<i class="dashicons dashicons-admin-settings mmp-menu-icon"></i>' . esc_html__('Settings', 'mmp'),
			'mmp_change_settings',
			'mapsmarkerpro_settings',
			array(MMP::get_instance('MMP\Menu\Settings'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('License settings', 'mmp'),
			'<i class="dashicons dashicons-admin-network mmp-menu-icon"></i>' . esc_html__('License', 'mmp'),
			'activate_plugins',
			'mapsmarkerpro_license',
			array(MMP::get_instance('MMP\Menu\License'), 'display')
		);
		add_submenu_page(
			'mapsmarkerpro_maps',
			'Maps Marker Pro - ' . esc_html__('Support', 'mmp'),
			'<i class="dashicons dashicons-sos mmp-menu-icon"></i>' . esc_html__('Support', 'mmp'),
			'activate_plugins',
			'mapsmarkerpro_support',
			array(MMP::get_instance('MMP\Menu\Support'), 'display')
		);
	}

	/**
	 * Loads the CSS for the admin menu
	 *
	 * @since 4.10
	 */
	public function admin_menu_css() {
		?>
		<style>
			.mmp-menu-icon {
				padding: 4px 4px 4px 0;
				width: 12px;
				height: 12px;
				font-size: 12px;
			}
		</style>
		<?php
	}

	/**
	 * Adds the menu to the admin bar
	 *
	 * @since 4.0
	 *
	 * @param WP_Admin_Bar $wp_admin_bar Admin bar object instance
	 */
	public function add_admin_bar_menu($wp_admin_bar) {
		$menus = array(
			array(
				'capability' => 'mmp_view_maps',
				'node' => array(
					'id'    => 'mmp',
					'title' => '<span class="ab-icon"></span><span class="ab-label">Maps Marker Pro</span>'
				)
			),
			array(
				'capability' => 'mmp_view_maps',
				'node' => array(
					'id'     => 'mmp-maps',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-editor-table"></i>' . esc_html__('List all maps', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_maps')
				)
			),
			array(
				'capability' => 'mmp_add_maps',
				'node' => array(
					'id'     => 'mmp-map',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-plus"></i>' . esc_html__('Add new map', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_map')
				)
			),
			array(
				'capability' => 'mmp_view_markers',
				'node' => array(
					'id'     => 'mmp-markers',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-editor-table"></i>' . esc_html__('List all markers', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_markers')
				)
			),
			array(
				'capability' => 'mmp_add_markers',
				'node' => array(
					'id'     => 'mmp-marker',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-plus"></i>' . esc_html__('Add new marker', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_marker')
				)
			),
			array(
				'capability' => 'mmp_use_tools',
				'node' => array(
					'id'     => 'mmp-tools',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-admin-tools"></i>' . esc_html__('Tools', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_tools')
				)
			),
			array(
				'capability' => 'mmp_change_settings',
				'node' => array(
					'id'     => 'mmp-settings',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-admin-settings"></i>' . esc_html__('Settings', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_settings')
				)
			),
			array(
				'capability' => 'activate_plugins',
				'node' => array(
					'id'     => 'mmp-license',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-admin-network"></i>' . esc_html__('License', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_license')
				)
			),
			array(
				'capability' => 'activate_plugins',
				'node' => array(
					'id'     => 'mmp-support',
					'parent' => 'mmp',
					'title'  => '<i class="mmp-ab-icon dashicons-sos"></i>' . esc_html__('Support', 'mmp'),
					'href'   => get_admin_url(null, 'admin.php?page=mapsmarkerpro_support')
				)
			)
		);

		foreach ($menus as $menu) {
			if (current_user_can($menu['capability'])) {
				$wp_admin_bar->add_node($menu['node']);
			}
		}
	}

	/**
	 * Loads the CSS for the admin bar menu
	 *
	 * @since 4.0
	 */
	public function admin_bar_css() {
		if (!is_admin_bar_showing()) {
			return;
		}

		?>
		<style>
			#wp-admin-bar-mmp .ab-item {
				cursor: pointer;
			}
			#wp-admin-bar-mmp .ab-item .ab-icon:before {
				content: url(<?= $this->get_icon_svg() ?>);
				display: inline-block;
				width: 20px;
				height: 20px;
				top: 3px;
			}
			@media (max-width: 782px) {
				#wpadminbar #wp-admin-bar-mmp {
					position: static;
				}
				#wp-admin-bar-mmp.menupop {
					display: block;
				}
				#wp-admin-bar-mmp .ab-item .ab-icon:before {
					width: 34px;
					height: 34px;
					top: 0;
				}
			}
			#wp-admin-bar-mmp .ab-item .mmp-ab-icon {
				display: inline-block;
				width: 12px;
				height: 12px;
				margin: 0;
				padding: 2px 4px 4px 0;
				line-height: 1;
				font-family: dashicons;
				font-size: 12px;
				font-weight: 400;
				font-style: normal;
				text-align: center;
				text-decoration: inherit;
				text-transform: none;
				text-rendering: auto;
				vertical-align: middle;
				speak: none;
			}
		</style>
		<?php
	}

	/**
	 * Returns the menu icon as SVG
	 *
	 * @since 4.29
	 */
	private function get_icon_svg($base64 = true) {
		$svg = '<svg viewBox="0 0 413.33334 413.33334" xmlns="http://www.w3.org/2000/svg"><path style="fill:#9ca2a7" d="m 291.52279,368.5404 -0.148,-0.005 -57.824,0.168 c -0.93067,-0.0653 -1.808,-0.5 -2.42267,-1.204 l -21.52133,-22.9 c -2.152,-2.28934 -1.06533,-6.04667 1.976,-6.83467 l 76.95067,-19.948 c 2.564,-0.66533 5.084,1.21867 5.172,3.86667 l 1.45066,43.83466 c -0.256,1.784 -1.764,3.06134 -3.63333,3.02267 M 152.084,187.23307 c -7.89467,-30.45467 10.46,-61.65467 40.91467,-69.54933 4.78133,-1.24 9.58133,-1.832 14.30666,-1.832 26.24133,0 50.18,18.268 55.86933,45.42133 2.748,13.11867 0.74534,26.908 -5.624,38.7 -7.628,14.12133 -20.47333,24.17067 -35.91733,28.17467 -30.45333,7.89066 -61.65466,-10.46 -69.54933,-40.91467 m 187.46146,-48.882 c -9.16134,-35.33866 -31.536,-64.994663 -63,-83.505329 -31.46534,-18.509333 -68.25467,-23.657333 -103.59467,-14.499999 -35.33866,9.162666 -64.99466,31.535999 -83.505328,62.999998 -18.510666,31.46667 -23.66,68.25733 -14.5,103.59466 9.336,36.016 55.899998,80.836 100.930668,124.18 3.32266,3.19733 6.63333,6.38533 9.92,9.56 l 34.38266,36.57733 c 3.28134,3.69734 7.98267,5.92 12.92533,6.10667 l 0.14934,0.005 57.884,-0.168 c 9.83466,0.276 18.00933,-7.13333 18.68,-16.956 l 0.024,-0.36933 -1.492,-45.09467 c -0.27734,-8.41333 0.83866,-16.81333 3.304,-24.86266 v 0 c 18.30133,-59.76 37.228,-121.55333 27.892,-157.568"/></svg>';

		if ($base64) {
			return 'data:image/svg+xml;base64,' . base64_encode($svg);
		}

		return $svg;
	}
}
